# 📦 CloudFlare ImgBed 上传器 - 详细安装指南

本指南将帮助您完成扩展的安装、配置和使用。适用于Edge、Chrome等Chromium内核浏览器。

## 🎯 安装前准备

### 系统要求
- **操作系统**：Windows 10/11, macOS 10.14+, Linux
- **浏览器**：Microsoft Edge 88+, Google Chrome 88+
- **网络**：能够访问您的CloudFlare ImgBed服务

### 文件结构检查
确保下载的扩展文件夹包含以下完整结构：
```
image-up/
├── 📄 manifest.json          # 扩展清单文件
├── 🔧 background.js          # 后台服务脚本
├── 📝 content.js             # 内容脚本
├── 🔔 notification.js        # 通知功能
├── 🎨 popup.html             # 配置界面
├── ⚙️ popup.js              # 配置逻辑
├── 📁 icons/                 # 图标文件夹
│   ├── icon.svg              # 主图标
│   ├── icon16.svg            # 16px图标
│   ├── icon48.svg            # 48px图标
│   └── icon128.svg           # 128px图标
├── 📖 README.md              # 说明文档
└── 📋 install.md             # 本安装指南
```

## 🚀 详细安装步骤

### 步骤1：打开浏览器扩展管理页面

#### Microsoft Edge
```
方法1：地址栏输入
edge://extensions/

方法2：菜单导航
右上角 ⋮ → 扩展 → 管理扩展
```

#### Google Chrome
```
方法1：地址栏输入
chrome://extensions/

方法2：菜单导航
右上角 ⋮ → 更多工具 → 扩展程序
```

### 步骤2：启用开发者模式

1. **找到开发者模式开关**
   - Edge：页面右上角"开发人员模式"
   - Chrome：页面右上角"开发者模式"

2. **启用开关**
   - 点击开关，确保变为蓝色/开启状态
   - 页面会显示额外的开发者选项

### 步骤3：加载扩展

1. **点击"加载已解压的扩展程序"按钮**
   - 按钮出现在开发者模式启用后

2. **选择扩展文件夹**
   - 浏览到下载的 `image-up` 文件夹
   - 选择整个文件夹（不是文件夹内的单个文件）
   - 点击"选择文件夹"确认

3. **确认加载成功**
   - 扩展出现在扩展列表中
   - 显示名称："CloudFlare ImgBed 上传器"
   - 状态显示为"已启用"

### 步骤4：验证安装

#### 检查清单
- [ ] 扩展在列表中显示为"已启用"
- [ ] 浏览器工具栏出现扩展图标 📷
- [ ] 右键网页显示"ImgBed 配置"菜单项
- [ ] 在图片上右键显示"上传图片到 ImgBed"选项

#### 可能的问题
```bash
❌ 扩展显示错误或警告
解决：检查文件结构是否完整，重新下载扩展文件

❌ 图标不显示
解决：刷新浏览器，或重新加载扩展

❌ 右键菜单不出现
解决：刷新网页，确保扩展已启用
```

## ⚙️ 首次配置指南

### 配置步骤

#### 1. 打开配置界面
```
方式1：点击工具栏扩展图标 📷
方式2：右键网页 → "ImgBed 配置"
方式3：扩展管理页面 → 扩展详情 → 扩展选项
```

#### 2. 基础配置（必填）
```yaml
API 地址: https://your-imgbed-domain.com
# 示例：https://img.example.com
# 注意：不要包含 /upload 路径

上传认证码: your-auth-code
# 可选项，取决于您的服务配置
# 如果服务不需要认证，可以留空
```

#### 3. 高级配置（可选）
```yaml
上传渠道:
  - telegram    # 推荐，速度快
  - cfr2        # CloudFlare R2
  - s3          # Amazon S3

文件命名方式:
  - default     # 前缀_原文件名
  - index       # 仅使用前缀
  - origin      # 仅使用原文件名
  - short       # 短链接格式

上传目录: "img/uploads"  # 可留空使用根目录

功能选项:
  ☑️ 服务端压缩 (仅Telegram)
  ☑️ 失败时自动重试
  ☑️ 显示上传通知
```

#### 4. 测试连接
```bash
1. 填写完配置后，点击"测试连接"按钮
2. 等待测试结果：
   ✅ "连接测试成功！" - 配置正确，可以使用
   ❌ "连接失败" - 检查API地址和认证码
```

#### 5. 保存配置
```bash
点击"保存配置"按钮
配置会自动保存到浏览器本地存储
```

### 配置示例

#### 个人博客配置
```json
{
  "apiUrl": "https://img.myblog.com",
  "authCode": "my-secret-token",
  "uploadChannel": "telegram",
  "uploadNameType": "default",
  "uploadFolder": "blog/2024",
  "serverCompress": true,
  "autoRetry": true
}
```

#### 团队共享配置
```json
{
  "apiUrl": "https://assets.company.com",
  "authCode": "team-shared-key",
  "uploadChannel": "cfr2",
  "uploadNameType": "short",
  "uploadFolder": "team/images",
  "serverCompress": false,
  "autoRetry": true
}
```

## 🎮 使用方法

### 1. 右键上传网页图片
```bash
操作步骤：
1. 在任意网页图片上右键
2. 选择"上传图片到 ImgBed"
3. 等待上传完成
4. 自动显示结果通知

支持格式：
- 直链：https://img.example.com/file/abc123.jpg
- Markdown：![image](https://img.example.com/file/abc123.jpg)
- BBCode：[img]https://img.example.com/file/abc123.jpg[/img]
```

### 2. 剪贴板图片上传
```bash
操作步骤：
1. 截图或复制图片到剪贴板
2. 在网页任意位置右键
3. 选择"上传剪贴板图片到 ImgBed"
4. 或使用快捷键：Ctrl+Shift+U

适用场景：
- 屏幕截图上传
- 从其他应用复制的图片
- 剪贴板中的图片数据
```

### 3. 拖拽文件上传
```bash
操作步骤：
1. 从文件管理器选择图片文件
2. 直接拖拽到网页任意位置
3. 松开鼠标，自动开始上传
4. 查看上传结果通知

支持格式：
JPG, JPEG, PNG, GIF, WebP, BMP, TIFF
```

### 4. 复制上传结果
```bash
通知框功能：
- 点击任意格式的链接自动复制到剪贴板
- 支持三种格式：直链、Markdown、BBCode
- 复制成功会显示绿色确认提示
- 通知框不会自动关闭，手动点击X关闭
```

## 🔧 故障排除

### 安装问题

#### 问题1：扩展加载失败
```bash
错误信息："无法加载扩展"
可能原因：
- 文件结构不完整
- manifest.json格式错误
- 权限不足

解决方案：
1. 重新下载完整的扩展文件
2. 检查文件夹权限
3. 尝试以管理员身份运行浏览器
```

#### 问题2：开发者模式无法启用
```bash
错误信息：开关无法切换或显示灰色
可能原因：
- 企业策略限制
- 浏览器版本过低
- 用户权限不足

解决方案：
1. 联系IT管理员检查企业策略
2. 更新浏览器到最新版本
3. 使用管理员账户
```

### 配置问题

#### 问题3：测试连接失败
```bash
错误信息："连接测试失败"
检查清单：
□ API地址格式正确（https://domain.com）
□ 网络能正常访问该地址
□ 认证码正确（如果需要）
□ 服务器正常运行

调试方法：
1. 在浏览器中直接访问API地址
2. 检查开发者工具Network标签
3. 确认服务器返回状态
```

#### 问题4：配置无法保存
```bash
错误信息："保存失败"或配置丢失
可能原因：
- 浏览器存储权限问题
- 存储空间不足
- 扩展权限不足

解决方案：
1. 清除浏览器缓存和数据
2. 重新安装扩展
3. 检查浏览器存储设置
```

### 使用问题

#### 问题5：右键菜单不显示
```bash
检查清单：
□ 扩展已启用
□ 页面已刷新
□ 在正确的元素上右键（图片/网页）
□ 没有其他扩展冲突

解决方案：
1. 刷新页面重试
2. 禁用其他可能冲突的扩展
3. 重启浏览器
```

#### 问题6：上传失败
```bash
常见错误及解决方案：

"Failed to fetch"
→ 检查网络连接和API地址

"403 Forbidden"
→ 检查认证码或服务器权限设置

"413 Request Entity Too Large"
→ 图片文件过大，尝试压缩后上传

"跨域图片上传失败"
→ 目标网站有防盗链，建议保存到本地后上传
```

## 🔄 更新和维护

### 更新扩展
```bash
方法1：手动更新
1. 下载新版本文件
2. 在扩展管理页面点击"重新加载"
3. 或删除旧版本后重新安装

方法2：自动更新（如果发布到商店）
浏览器会自动检查和安装更新
```

### 备份配置
```bash
导出配置：
1. 打开开发者工具（F12）
2. 在Console中执行：
   chrome.storage.sync.get(null, console.log)
3. 复制输出的配置数据

导入配置：
1. 在Console中执行：
   chrome.storage.sync.set({配置数据})
```

### 卸载扩展
```bash
完全卸载步骤：
1. 打开扩展管理页面
2. 找到"CloudFlare ImgBed 上传器"
3. 点击"删除"按钮
4. 确认删除
5. 清除相关数据（可选）：
   - 浏览器设置 → 隐私和安全 → 清除浏览数据
   - 选择"扩展数据"
```

## 📞 获取帮助

### 自助排查
1. 查看浏览器开发者工具Console错误信息
2. 检查Network标签中的请求详情
3. 确认扩展权限设置
4. 尝试重新安装扩展

### 联系支持
如果问题仍未解决，请提供以下信息：
- 操作系统和浏览器版本
- 扩展版本号
- 具体错误信息和截图
- 复现步骤
- 开发者工具中的错误日志

**联系方式：**
- 📧 邮箱：support@your-domain.com
- 🐛 GitHub Issues：[项目地址]/issues
- 💬 QQ群：123456789

---

## ✅ 安装完成检查清单

安装完成后，请确认以下功能正常：

- [ ] 扩展图标显示在浏览器工具栏
- [ ] 右键网页显示"ImgBed 配置"菜单
- [ ] 右键图片显示"上传图片到 ImgBed"菜单
- [ ] 配置界面可以正常打开和保存
- [ ] 测试连接功能正常
- [ ] 能够成功上传图片并获得链接
- [ ] 通知显示正常，格式复制功能正常
- [ ] 快捷键 Ctrl+Shift+U 可以触发剪贴板上传

**🎉 恭喜！您已成功安装并配置了CloudFlare ImgBed上传器扩展！**

现在您可以享受便捷的图片上传体验了。如有任何问题，请参考故障排除部分或联系技术支持。